#ifndef INC_PWM_LIB_H_
#define INC_PWM_LIB_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "stm32f4xx_hal.h"
#include <stdint.h>

typedef struct {

	TIM_HandleTypeDef *handle;

	uint32_t channel;
	uint32_t prescaler;

	float frequency;
	float duty_cycle;

} pwmDevice;

void PWM_Initialise (pwmDevice         *dev,
		             TIM_HandleTypeDef *handle,
					 uint32_t           ch,
					 float              init_frq,
					 float              init_dc);

void PWM_Set_FR (pwmDevice *dev, float frequency);
void PWM_Set_DC (pwmDevice *dev, float duty, uint32_t ch);
void PWM_Start  (pwmDevice *dev, uint32_t ch);
void PWM_Stop   (pwmDevice *dev, uint32_t ch);

float PWM_GetTIM_DC      (pwmDevice *dev);
float PWM_GetTIM_UsrFreq (pwmDevice *dev);

uint32_t PWM_GetTIM_BaseFreq (TIM_TypeDef *TIMx);
uint8_t  PWM_Is32bitTimer    (TIM_TypeDef *TIMx);

void PWM_ComputePscArr   (TIM_TypeDef *TIMx,
		                  float        frequency,
						  uint32_t    *psc_out,
						  uint32_t    *arr_out);

#ifdef __cplusplus
}
#endif

#endif
